/** @file   MusicControlObject.h
 * @brief   Declaration of MusicControlObject class.
 * @version $Revision: 1.1 $
 * @date    $Date
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_MUSICCONTROLOBJECT_H
#define H_WWW_MUSICCONTROLOBJECT_H

#include "GameObject.h"
#include "MUsableObject.h"

namespace WeWantWar {


// Forward declarations
class MMp3PlayerProvider;

/** Id of the mp3-player control obejct. */
const int KMp3PlayerControlObjectId = 1000000;

/** @class  MusicControlObject
 * @brief   This object controls the MP3 player. The object table always has 
 *          one object of this type.
 * @author  Tomi Lamminsaari
 *
 */
class MusicControlObject : public GameObject
{
public:
  /** Default constructor.
   * @param   aProvider         Pointer object that provider the mp3 player.
   *                            Ownership is not tranferred.
   */
  MusicControlObject( MMp3PlayerProvider& aProvider );

  /** Destructor
   */
  virtual ~MusicControlObject();

private:
  MusicControlObject( const MusicControlObject& aAnother );
  MusicControlObject& operator= ( const MusicControlObject& aAnother );
public:

private:  // Inherited methods
  /** From GameObject.
   */
  virtual void update();
  
  /** From GameObject
   */
  virtual void redraw( RedrawQueue* aQueue );
   
  /** From GameObject
   */
  virtual bool hitByBullet( Bullet* aBullet );
  
  /** From GameObject
   */
  virtual void kill();
  
  /** From GameObject.
   */
  virtual void makeSound( GameObject::SoundID aSoundId ) const;
  
  /** From GameObject.
   */
  virtual ObjectID::Type objectType() const;
  
  /** From GameObject
   */
  virtual bool reloading() const;

public: // New methods
  /** Activates the volume fading event.
   * @param   aToVolume         The volume where to fade.
   * @param   aDuration         How many updates it takes to reach the
   *                            target volume.
   */
  void launchVolumeFade( int aToVolume, int aDuration );
  
  /** Sets the mp3 player's playback volume.
   * @param   aVolume           The volume.
   */
  void launchSetVolume( int aVolume );
  
  /** Changes the song being played.
   * @param   aSongNumber       Index of the song.
   */
  void launchChangeSong( int aSongIndex );
  
  /** Stops the playback.
   */
  void launchStopSong();
   
private:
  
  MMp3PlayerProvider& iProvider;
  float iCurrentVolume;
  float iVolumeChangePerStep;
  int iUpdatesToGo;
};

};  // end of namespace

#endif
